<?php $__env->startSection('title','CARRISOFT V2: BON DE COMMANDE'); ?>


<?php $__env->startSection('content'); ?>
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;">
        <div class="col-12 col-sm-12 col-md-12">
            <h5 class="ml-5">I<?php echo e(__('messages.INVENTAIRE GLOBAL')); ?></h5>
            <div class="col-12 col-md-4 float-left">
                <a href="<?php echo e(route('invsi.invglobal')); ?>" class="btn btn-success"><i class="fa fa-globe"></i> <?php echo e(__('messages.Inventaire Global')); ?></a>
            </div>
            <div class="col-12 col-sm-4 col-md-4 float-left">
                <a href="<?php echo e(route('invsi.invcentre')); ?>" class="btn btn-primary"><i class="fa fa-database"></i> <?php echo e(__('messages.Inventaire par Centre')); ?></a>
            </div>
            <div class="col-12 col-sm-4 col-md-4 float-right">
                <a href="<?php echo e(route('invsi.invproduit')); ?>" class="btn btn-warning"><i class="fa fa-info"></i><?php echo e(__('messages.Fiche de Stock')); ?></a>
            </div>
        </div>
        <br>

        <div class="info-box mb-1">
            <div class="row input-daterange">
                <div class="col-12 col-md-3">
                    <input type="text" name="from_date" id="from_date" class="form-control" placeholder="<?php echo e(__('messages.Date Debut')); ?>" readonly />
                </div>
                <div class="col-12 col-md-3">
                    <input type="text" name="to_date" id="to_date" class="form-control" placeholder="<?php echo e(__('messages.Date Fin')); ?>" readonly />
                </div>

                <div class="col-12 col-md-6">
                    <button type="button" name="filter" id="filter" class="btn btn-warning"><?php echo e(__('messages.Rechercher')); ?></button>
                    <button type="button" name="imprimer" id="imprimer" class="btn btn-primary"><?php echo e(__('messages.Imprimer')); ?></button>
                    <button type="button" name="refresh" id="reset" class="btn btn-danger"><?php echo e(__('messages.Actualiser')); ?></button>
                </div>
            </div>
            <!-- /.info-box-content -->
        </div>

        <div class="col-md-12">
            <div class="info-box">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered" id="inventaires">
                        <thead>
                        <tr class="cart_menu">
                            <td class="price"><?php echo e(__('messages.Produit')); ?></td>
                            <td class="price"><?php echo e(__('messages.Initial')); ?></td>
                            <td class="price"><?php echo e(__('messages.Achat')); ?></td>
                            <td class="price"><?php echo e(__('messages.Sortie')); ?></td>
                            <td class="total"><?php echo e(__('messages.Solde')); ?></td>
                            <td><?php echo e(__('messages.Infos')); ?></td>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <!--Supprimer le produit -->
        <main id="confirmModal" class="modal fade" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h2 class="modal-title"><?php echo e(__('messages.Confirmation')); ?></h2>
                    </div>
                    <div class="modal-body">
                        <h5 align="center" style="margin:0;"><?php echo e(__('messages.annuler commande')); ?></h5>
                    </div>
                    <div class="modal-footer">
                        <button type="button" name="ok_button" id="ok_button" class="btn btn-danger"><?php echo e(__('messages.Oui')); ?></button>
                        <button type="button" class="btn btn-primary" data-dismiss="modal"><?php echo e(__('messages.Annuler')); ?></button>
                    </div>
                </div>
            </div>
        </main>

    </main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra-js'); ?>
    <script>
        $(document).ready(function(){
            $('.input-daterange').datepicker({
                todayBtn:'linked',
                format:'yyyy-mm-dd',
                autoclose:true
            });

            load_data();

            function load_data(from_date = '', to_date = '') {
                $('#inventaires').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url:'<?php echo e(route("invsi.invglobal")); ?>',
                        data:{from_date:from_date, to_date:to_date}
                    },
                    columns: [
                        {
                            data:'pdt_lib',
                            name:'pdt_lib'
                        },
                        {
                            data:'pdt_ini',
                            name:'pdt_ini'
                        },
                        {
                            data:'pdt_ent',
                            name:'pdt_ent'
                        },
                        {
                            data:'pdt_sor',
                            name:'pdt_sor'
                        },
                        {
                            data:'pdt_act',
                            name:'pdt_act'
                        },
                        {
                            data:'produit_id',
                            name:'produit_id',
                            render:function (data, type, row) {
                                return "<a href='#' id='"+row.produit_id+"' class='btn btn-danger details'><i class='fa fa-info'></i></a>"}
                        }

                    ]
                });
            }

            $('#filter').click(function(){
                var from_date = $('#from_date').val();
                var to_date = $('#to_date').val();
                if(from_date != '' && to_date != '')
                {
                    $('#inventaires').DataTable().destroy();
                    load_data(from_date, to_date);
                }
                else
                {
                    alert('<?php echo e(__('messages.Selectionner la periode')); ?>');
                }
            });

            $('#reset').click(function(){
                $('#from_date').val('');
                $('#to_date').val('');
                $('#inventaires').DataTable().destroy();
                load_data();
            });

            $('#imprimer').click(function(){
                var debut = document.getElementById('from_date').value;
                var fin = document.getElementById('to_date').value;

                var newWin = window.open();
                var the_url = "invsi.print_invglobal/"+debut+"/"+fin;
                $.ajax({
                    type: "GET", url: the_url, data: {},
                    success: function(data){
                        newWin.document.write(data);;
                    }
                    ,error: function() {
                    }
                });
            });

            $(document).on('click', '.details', function(){
                var id = $(this).attr('id');
                var debut = document.getElementById('from_date').value;
                var fin = document.getElementById('to_date').value;

                var newWin = window.open();
                var the_url = "invsi.details/"+debut+"/"+fin+"/"+id;
                $.ajax({
                    type: "GET", url: the_url, data: {},
                    success: function(data){
                        newWin.document.write(data);
                    }
                    ,error: function() {
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.adminlayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\gas_online\resources\views/inventairesi/invglobal.blade.php ENDPATH**/ ?>